#!/usr/bin/gnuplot

set term postscript enhanced "Times"
set out "sha.ps"

set xl "{/Times-Oblique X} / cm"
set yl "{/Times-Oblique Y} / cm"

set size ratio -1

set zeroaxis
set nokey

load "ciselnik.plt"

call "popisky.plt" "front"

set label "S" at graph 0.5,graph 1.02 center
set label "V" at graph 1.015,graph 0.5 center

set style line 1 lw 2.5 pt 1 ps 1.5
set style line 2 lt 1 lw 1
set style line 3 lw 1 pt 1 ps 2.5
set style line 4 lt 2 lw 0.5
set style line 5 lt 4 lw 0.5 pt 4 ps 0.5

p "datum_prumet.dat"   u 4:5 w lp ls 5,\
  "lambert.dat" u 1:2 w l ls 4,\
  "elipsa.dat"  u 2:3 w l ls 2,\
  "hodin.dat"   u 2:3 w p ls 1,\
  "datum.dat"   u 2:3 w p ls 3

########################################################################

set term png small xffffff x000000 x000000 xff0000 xee9900 x2020c0 x8000c0
set out "sha.png"
set size 1.2,1.2

set xl "X / cm"
set yl "Y / cm"

set style line 1 lt 1 lw 2.5 pt 1 ps 1.5
set style line 2 lt 1 lw 1
set style line 3 lt 3 lw 1 pt 1 ps 2.5
set style line 4 lt 2 lw 0.5
set style line 5 lt 4 lw 0.5 pt 3 ps 0.5

rep

# zobrazeni sirsiho okoli SH s datovymi krivkami
set out "sha2.png"
set size 0.55,0.55

set nolabel

sc=2.75
set xr [sc*x1:sc*x2]
set yr [sc*y1:sc*y2]

rep

set size 1,1
set xr [x1:x2]
set yr [y1:y2]

pi=-1

