#!/usr/bin/awk -f

# 4d.awk
# Prevod datovych souboru SHC do 3D, s vyuzitim souradnic
#   bazovych vektoru uvedenych v shc.out.
# Miroslav Broz (miroslav.broz@email.cz), Jul 17th 2007

BEGIN{
  i=ARGV[1];
  j=ARGV[2];
  k=ARGV[3];

  ARGV[1]=ARGV[2]=ARGV[3]="";

  SHOUT="shc.out";
  ARGV[1]=SHOUT;

  r0[1]=0;
  r0[2]=0;
  r0[3]=0;

  eps=1e-3;
}
(FILENAME==SHOUT) && /^# a0 /{
  a0[1]=$5;
  a0[2]=$7;
  a0[3]=$9;
}
(FILENAME==SHOUT) && /^# b0 /{
  b0[1]=$5;
  b0[2]=$7;
  b0[3]=$9;
}
(FILENAME==SHOUT) && /^# n0 /{
  n0[1]=$5;
  n0[2]=$7;
  n0[3]=$9;
}
(FILENAME==SHOUT) && /^# x1 /{
  x1=$4;
  y1=$9;
}
(FILENAME==SHOUT) && /^# x2 /{
  x2=$4;
  y2=$9;
}
(FILENAME!=SHOUT) && (NF==0){
  print; print;	# double all empty lines due to splot
}
(FILENAME!=SHOUT) && (NF>0) && !/^#/{
  x0=$i;
  y0=$j;
  if (k==0) {
    z0=0;
  } else {
    z0=$k;
  }

  x = r0[1] + a0[1]*x0 + b0[1]*y0 + n0[1]*z0;
  y = r0[2] + a0[2]*x0 + b0[2]*y0 + n0[2]*z0;
  z = r0[3] + a0[3]*x0 + b0[3]*y0 + n0[3]*z0;

# clip date curves <- this should NOT be done for nodus, which might be OUTSIDE the dial borders
  if ((x0>x1-eps) && (x0<x2+eps) && (y0>y1-eps) && (y0<y2+eps)) {
#    print x,y,z;
    print -y,-x,z;
  } else {
    print "";
  }
}

