#!/usr/bin/gnuplot

# shc_4d.plt
# Vykresleni slunecnich hodin ve 3D (z datovych soboru programu SHC)
# Miroslav Broz (miroslav.broz@email.cz), Jul 17th 2007

set datafile missing "?"
set encoding iso_8859_1

reset

set term x11 enhanced

set xl "x / cm"
set yl "y / cm"
set zl "z / cm"

load "ciselnik.plt"

set size ratio -1

sc=1.25
#sc=1.5
#sc=1
set yr [sc*x1:sc*x2]
set xr [sc*x1:sc*x2]
set zr [sc*y1:sc*y2]

set view ,,1,(y2-y1)/(x2-x1)

tmp=0.075
set label "S" at graph 0.5,1+tmp center
set label "J" at graph 0.5,0-tmp center
set label "V" at graph 1+tmp,0.5 center
set label "Z" at graph 0-tmp,0.5 center

#tmp=100;
#set xr [-tmp:tmp]
#set yr [-tmp:tmp]
#set zr [-tmp:tmp]
#set view ,,1,1

set ticslevel 0

load "popisky_4d.plt"

#set xtics 100
#set ytics 100
#set mxtics 10
#set mytics 10
#set grid
set zeroaxis
set nokey

set style line  1 lt 8
set style line  2 lt 3
set style line  3 lt 15 pt 13 ps 1.25
set style line  4 lt 1 lw 3 pt 7 ps 1.75
set style line  5 lt 4
set style line  6 lt 7
set style line  7 lt 6
set style line  8 lt -1
set style line  9 lt 1
set style line 10 lt 5
set style line 11 lt 1
set style line 12 lt 4
set style line 13 lt -1 lw 0.5

sp "<./4d.awk 1 2 0 horiz_rysky.dat"    w l  ls  8,\
   "<./4d.awk 3 4 0 vyska_prumet.dat"   w l  ls 12,\
   "<./4d.awk 2 3 0 azimut_rysky.dat"   w l  ls 11,\
   "<./4d.awk 2 3 0 zapad_rysky.dat"    w l  ls  7,\
   "<./4d.awk 2 3 0 vychod_rysky.dat"   w l  ls  6,\
   "<./4d.awk 2 3 0 temporal_rysky.dat" w l  ls 10,\
   "<./4d.awk 4 5 0 analema_prumet.dat" w l  ls  9,\
   "<./4d.awk 4 5 0 datum_prumet.dat"   w l  ls  1,\
   "<./4d.awk 2 3 0 hodin_rysky.dat"    w l  ls  2,\
   "<./4d.awk 4 5 0 hodin_prumet.dat"        ls  3,\
   "<./4d.awk 1 2 0 ciselnik.dat"       w l  ls 13,\
   "<./4d.awk 1 2 3 nodus.dat"          w lp ls  4

pa -1


