#!/usr/bin/gnuplot

set tit "Analema (pro rok 2000)"
set xl "korekce casu (-E) / min"
set yl "deklinace Slunce / stupen"

set xr [-18:18]
set yr [-25:25]

set grid
set size ratio 1.5
set yzeroaxis lt 1 lw 2

set style line 1 pt 1 ps 0.5
set style line 2 pt 1 ps 1.5
f(x)=(x>180) ? x-360 : x
g(x)=-f(x)/15.*60.	# prevod na minuty

load 'label.plt'

p "sunah.out" u (g($11)):12 not w p ls 1,\
  "<awk '!/^#/{n++}((n%10)==1){print}' sunah.out" u (g($11)):12 not w p ls 2

#pause -1

set term postscript eps 10
set out "analema.eps"

rep

set term postscript portrait 10
set out "analema.ps"

set size
set xtics 1
set ytics 1

rep

set term table
set out "analema.dat"

rep

