#!/usr/bin/awk -f

BEGIN{
  m[1]="I";
  m[2]="II";
  m[3]="III";
  m[4]="IV";
  m[5]="V";
  m[6]="VI";
  m[7]="VII";
  m[8]="VIII";
  m[9]="IX";
  m[10]="X";
  m[11]="XI";
  m[12]="XII";

  print "# datum / MM/DD & korekce casu (-E) / min:s & korekce (-E) / min"

  file = "casova_rce.txt";
  print "# Casova rovnice: datum & korekce casu (-E)" >file;
}
!/^#/{
  n++;
}
!/^#/{
  t = $11;
  if (t > 180.) { t = t - 360.; }
  t = -t/15.*60.;
  ttmp = t + 0.5/60.;

  sig = plusminus(ttmp);
  ttmp = abs(ttmp);
  min = int(ttmp);
  sec = int((ttmp-min)*60.)

  mon = $3;
  day = $4;

  print mon "/" day "	" sig min ":" sec "	" t;
}
((n%10)==1){
  if (length(day) < 2) {
    day = " " day;
  }
  if (length(sec) < 2) {
    sec = " " sec;
  }
  min = sig min;
  if (length(min) < 3) {
    min = " " min;
  }
  print pad(day ". " m[mon] ".", 10) min " min " sec " s" >>file;
}

func abs(x) {
  if (x >= 0.) {
    return x;
  } else {
    return -x;
  }
}

func plusminus(x) {
  if (x >= 0.) {
    return "+";
  } else {
    return "-";
  }
}

func pad(s,n, t,i) {
  t = "";
  for (i = length(s); i <= n; i++) {
    t = t " ";
  }
  t = s t;
  return t;
}

