#!/usr/bin/gnuplot

# shc.plt
# Vykresleni ciselniku slunecnich hodin (z datovych soboru programu SHC).
# Miroslav Broz (miroslav.broz@email.cz), Jan 2nd 2005

# Vykresleni ciselniku slunecnich hodin v meritku 1:1 ve formatu EPS.

set datafile missing "?"
set encoding iso_8859_1

# tlousky car v EPS/PS
tl_datum	= 30
tl_hodin	= 50
tl_cisel	= 50
tl_horiz	= 20
tl_vychod	= 20
tl_zapad = tl_vychod
tl_analema	= 20
tl_temporal	= 30
tl_azimut	= 20
tl_vyska = tl_azimut

set term postscript eps
set out "shc.tmp"

sc = -1
load "ciselnik.plt"
in = 2.54
set size (x2-x1)/(5*in),(y2-y1)/(3.5*in)

# standardni skala tloustky car
if (sc<0) sc = (x2-x1)/200

set xl ""
set yl ""
set nolabel
set noxtics
set noytics
set noborder
set nozeroaxis
set nokey
set origin 0,0
set bmargin 0
set tmargin 0
set lmargin 0
set rmargin 0

set style line  1 lt 1 lw tl_datum * sc
set style line  2 lt 1 lw tl_hodin * sc
set style line  3 lt 1 lw tl_cisel * sc
set style line  6 lt 1 lw tl_vychod * sc
set style line  7 lt 1 lw tl_zapad * sc
set style line  8 lt 1 lw tl_horiz * sc
set style line  9 lt 1 lw tl_analema * sc
set style line 10 lt 1 lw tl_temporal * sc
set style line 11 lt 1 lw tl_azimut * sc
set style line 12 lt 1 lw tl_vyska * sc

p "horiz_rysky.dat"    u 1:2 w l ls  8,\
  "vyska_prumet.dat"   u 3:4 w l ls 12,\
  "azimut_rysky.dat"   u 2:3 w l ls 11,\
  "zapad_rysky.dat"    u 2:3 w l ls  7,\
  "vychod_rysky.dat"   u 2:3 w l ls  6,\
  "temporal_rysky.dat" u 2:3 w l ls 10,\
  "analema_prumet.dat" u 4:5 w l ls  9,\
  "datum_prumet.dat"   u 4:5 w l ls  1,\
  "hodin_rysky.dat"    u 2:3 w l ls  2,\
  "ciselnik.dat"       u 1:2 w l ls  3

sc = sc * 0.5	# PS je 2x vetsi!
set style line  1 lt 1 lw tl_datum * sc
set style line  2 lt 1 lw tl_hodin * sc
set style line  3 lt 1 lw tl_cisel * sc
set style line  6 lt 1 lw tl_vychod * sc
set style line  7 lt 1 lw tl_zapad * sc
set style line  8 lt 1 lw tl_horiz * sc
set style line  9 lt 1 lw tl_analema * sc
set style line 10 lt 1 lw tl_temporal * sc
set style line 11 lt 1 lw tl_azimut * sc
set style line 12 lt 1 lw tl_vyska * sc

set term postscript portrait
set out "shc_A4.tmp"

set size (x2-x1)/(7*in),(y2-y1)/(10*in)

rep

########################################################################

# Vykresleni zmenseneho ciselniku s popisky v PostScriptu a PNG.

reset

set term postscript landscape enhanced fontfile add "Luxi.pfa" "Times"
set out "shc.ps"

set xl "{/Times-Oblique X} / cm"
set yl "{/Times-Oblique Y} / cm"

load "ciselnik.plt"
set size ratio -1

load "popisky.plt"

#set xtics 100
#set ytics 100
#set mxtics 10
#set mytics 10
#set grid
set zeroaxis
set nokey

set style line  1 lt 1
set style line  2 lt 2
set style line  3 lt 3 pt 1 lw 2
set style line  4 lt 1 lw 3 pt 7
set style line  5 lt 5 lw 2
set style line  6 lt 4
set style line  7 lt 6
set style line  8 lt 1
set style line  9 lt 1
set style line 10 lt 3
set style line 11 lt 7
set style line 12 lt 8

p "horiz_rysky.dat"    u 1:2 w l  ls  8,\
  "vyska_prumet.dat"   u 3:4 w l  ls 12,\
  "azimut_rysky.dat"   u 2:3 w l  ls 11,\
  "zapad_rysky.dat"    u 2:3 w l  ls  7,\
  "vychod_rysky.dat"   u 2:3 w l  ls  6,\
  "temporal_rysky.dat" u 2:3 w l  ls 10,\
  "analema_prumet.dat" u 4:5 w l  ls  9,\
  "datum_prumet.dat"   u 4:5 w l  ls  1,\
  "hodin_rysky.dat"    u 2:3 w l  ls  2,\
  "hodin_prumet.dat"   u 4:5      ls  3,\
  "nodus.dat"          u 1:2 w lp ls  4,\
  "nodus.dat"          u 3:2 w l  ls  5

########################################################################

#set term png small xffffff x000000 x000000 xff0000 x0000ee xeecc00 xff0000 xaa00aa xeeee00 x00eeee x000000 xff6633 x666666 x008888 x22aa00
set term png giant xffffff x000000 x000000 xff0000 x0000ee xeecc00 xff0000 xaa00aa xeeee00 x00eeee x000000 xff6633 x666666 x008888 x22aa00

set out "shc.png"
#set size 1.2,1.2
set size 2.4,2.4

load "napis.plt"

set xl "X / cm"
set yl "Y / cm"

lw=3

set style line  1 lt 1 lw lw
set style line  2 lt 2 lw lw
set style line  3 lt 3 pt 7 lw lw
set style line  4 lt 4 lw 3*lw pt 7 ps 1.5
set style line  5 lt 5 lw 2*lw
set style line  6 lt 6 lw lw
set style line  7 lt 7 lw lw
set style line  8 lt 8 lw lw
set style line  9 lt 9 lw lw
set style line 10 lt 10 lw lw
set style line 11 lt 11 lw lw
set style line 12 lt 12 lw lw

rep

set size 1,1

# used by shc_*.plt
pi=-1


