#!/bin/sh

# popisky_4d.sh
# Prevod popisku ze 2D do 3D.
# Miroslav Broz (miroslav.broz@email.cz), Jul 17th 2007

awk '
  !/^#/{
    print gensub(".*at *([-0-9.E]+) *, *([-0-9.E]+) *.*", "\\1 \\2", 1, $0);
  }' \
  popisky.plt > popisky.tmp

./4d.awk 1 2 0 popisky.tmp > popisky_4d.tmp

awk '
  (FILENAME==ARGV[1]){
    i++;
    if (NF>=3) {
      l[i]=$1 "," $2 "," $3;
    } else {
      l[i]="";
    }
  }
  (FILENAME!=ARGV[1]) && !/^#/{
    j++;
    if (length(l[j]) > 0) {
      print gensub("(.* at *)[-0-9E,. ]+(.*)", "\\1" l[j] "  \\2", 1, $0);
    }
  }' \
  popisky_4d.tmp popisky.plt \
  | awk '!/" *Ns* *"/' \
  > popisky_4d.plt

./4d.awk 1 2 3 nodus.dat \
  | awk '(NR==2){ print "set label \"  N\" at " $1 "," $2 "," $3 " left"; }' \
  >> popisky_4d.plt



