#!/usr/bin/gnuplot

if (pi>0) load "shc.plt"

load "popisky.plt"

set xl "{/Times-Oblique X} / cm"
set yl "{/Times-Oblique Y} / cm"

set noxlabel
set noylabel

lw=3

set style line  1 lt 8 lw lw
set style line  2 lt 3 lw lw
set style line  3 lt 15 pt 13 ps 1.5
set style line  4 lt 1 lw 5 pt 7 ps 1.25
set style line  5 lt 4 lw 1
set style line  6 lt 6 lw lw
set style line  7 lt 9 lw lw
set style line  8 lt -1 lw 0.5
set style line  9 lt 1 lw lw
set style line 10 lt 5 lw lw
set style line 11 lt 4 lw 2
set style line 12 lt 2 lw 2

set term postscript eps color solid enhanced fontfile add "Luxi.pfa" "Times"
set out "shc_eps.eps"

set size 0.7,0.7
set noxtics
set noytics
set noborder

#rep

p "horiz_rysky.dat"    u 1:2 w l  ls  8,\
  "vyska_prumet.dat"   u 3:4 w l  ls 12,\
  "azimut_rysky.dat"   u 2:3 w l  ls 11,\
  "zapad_rysky.dat"    u 2:3 w l  ls  7,\
  "vychod_rysky.dat"   u 2:3 w l  ls  6,\
  "temporal_rysky.dat" u 2:3 w l  ls 10,\
  "analema_prumet.dat" u 4:5 w l  ls  9,\
  "datum_prumet.dat"   u 4:5 w l  ls  1,\
  "hodin_rysky.dat"    u 2:3 w l  ls  2,\
  "nodus.dat"          u 1:2 w lp ls  4,\
  "nodus.dat"          u 3:2 w l  ls  5



