#!/usr/bin/perl

# optimalizace.pl
# Vypocet chi^2 pro ruzne parametry ciselniku pocitaneho SHC.
# Miroslav Broz (miroslav.broz@email.cz), May 15th 2006

$phi1 = 47.0;	# deg; zemepisna sirka
$phi2 = 50.1;
$dphi = 0.1;
$d_nodus1 = 45.5;	# cm; delka nodu
$d_nodus2 = 47.5;
$dd_nodus = 0.1;

$eps = 1.e-3;
$n_phi = int(($phi2-$phi1+$eps)/$dphi);
$n_d_nodus = int(($d_nodus2-$d_nodus1+$eps)/$dphi);

print "# n_phi = $n_phi\n";
print "# n_d_nodus = $n_d_nodus\n";
print "# phi [deg] & d_nodus [cm] & chi^2\n";

`mkdir tmp`;

for ($phi = $phi1; $phi <= $phi2+$eps; $phi = $phi + $dphi) {
  for ($d_nodus = $d_nodus1; $d_nodus <= $d_nodus2+$eps; $d_nodus = $d_nodus + $dd_nodus) {

    $PHI = sprintf("%04.1f", $phi);
    $D_NODUS = sprintf("%05.1f", $d_nodus);

    open(OUT,">shc.in_optimalizace");
    print OUT <<EOF ;
# shc config file, vers. 17. 1. 2005
# parameters: phi lambda az ht x1 y1 x2 y2 d_nodus dt dvz dd daz dht dah ndate gnomon t_horiz t_hodin t_SEC t_letni t_prodluz t_delkadne t_vychod t_zapad t_temporal t_analema cast_analemy t_azimut t_vyska
$PHI
14:24:55
90 0
-290 -174
67 30
$D_NODUS
1:0:0
1:0:0
0:0:5
10
10
2
7
1
0
1
0
0
0
0
0
0
0
0
0
0
0

EOF
     close(OUT);

     `./shc.sh`;
     `./chi2.pl > chi2.out`;

#     `cp shc_BODY.ps tmp/shc_BODY.ps_$PHI"_"$D_NODUS`;
     `cp shc_BODY.png tmp/shc_BODY.png_$PHI"_"$D_NODUS`;
     `cp chi2.out tmp/chi2.out_$PHI"_"$D_NODUS`;

     open(IN,"<chi2.out");
     read(IN,$in,-s IN);
     close(IN);
     $in =~ s/.*chi2 = ([0-9\.]+).*/$1/s;
     $chi2 = $in;

     print "$PHI $D_NODUS $chi2\n";
  }

  print "\n";
}

exit;


