#!/usr/bin/gnuplot

set xl "ht [deg]"
set yl "d_nodus [cm]"
set zl "chi^2"

set logscale z

set ticslevel 0
set grid
set nokey

set contour base
set cntrparam levels auto

set style line 1 lt 1
set style line 2 lt 3 lw 5 pt 1 ps 10
set style line 3 lt 2 lw 5 pt 1 ps 5

sp "optimalizace.out" u 1:2:3 w l ls 1,\
   "optimalizace.min" u 2:3:1 w p ls 2,\
   "VYPOCET.dat"      u 1:2:($3*10) w p ls 3
pa -1

set term png small
set out "optimalizace.png"
rep

q



set dgrid3d 21,21,16
sp "optimalizace.out" u 1:2:3 w l,\
   "optimalizace.min" u 2:3:1 w p
pa -1


