#!/usr/bin/awk -f

BEGIN{
  d1 = ARGV[1];
  d2 = ARGV[2];
  ARGV[1]=ARGV[2]="";
}
/^# P /{
  P[1] = $5;
  P[2] = $7;
  P[3] = $9;
}
/^# N /{
  N[1] = $5;
  N[2] = $7;
  N[3] = $9;
}
/^# Ns /{
  Ns[1] = $5;
  Ns[2] = $7;
  Ns[3] = $9;
}
END{
  D_NP = D_(N,P);
  for (i=1; i<=3; i++) {
    np[i] = (N[i]-P[i])/D_NP;
    N1[i] = N[i] + d1 * np[i];
    N2[i] = N[i] + d2 * np[i];
  }

  Ns1[1] = N1[1]; Ns1[2] = N1[2]; Ns1[3] = 0.;
  Ns2[1] = N2[1]; Ns2[2] = N2[2]; Ns2[3] = 0.;
  ds1 = D_(Ns,Ns1);
  ds2 = D_(Ns,Ns2);

  print "# body kulisoveho ukazatele: Ns1, N1, N, N2, Ns2"; 
  print "# |NP| = " D_NP " cm";
  print "# d1 = " d1 " cm, ds1 = " ds1 " cm";
  print "# d2 = " d2 " cm, ds2 = " ds2 " cm"; 
  print Ns1[1], Ns1[2], Ns1[3];
  print  N1[1],  N1[2],  N1[3];
  print   N[1],   N[2],   N[3];
  print  N2[1],  N2[2],  N2[3];
  print Ns2[1], Ns2[2], Ns2[3];

  PLT="KULISA.lab";
  print "set label \" Ns1\" at " Ns1[1] "," Ns1[2] "," Ns1[3] >PLT;
  print "set label \" N1\"  at "  N1[1] ","  N1[2] ","  N1[3] >PLT;
  print "set label \" N\"   at "   N[1] ","   N[2] ","   N[3] >PLT;
  print "set label \" N2\"  at "  N2[1] ","  N2[2] ","  N2[3] >PLT;
  print "set label \" Ns2\" at " Ns2[1] "," Ns2[2] "," Ns2[3] >PLT;

  OUT="KULISA_2d.out";
  print d1, 0.    >OUT;
  print d1, N1[3] >OUT;
  print 0., N[3]  >OUT;
  print d2, N2[3] >OUT;
  print d2, 0.    >OUT;
}

func D_(a,b) {
  return sqrt((a[1]-b[1])**2 + (a[2]-b[2])**2 + (a[3]-b[3])**2);
}

