#!/usr/bin/gnuplot

# KULISA.plt
# Kresleni kulisoveho ukazatele (dle vystupu KULISA.awk).
# Miroslav Broz (miroslav.broz@email.cz), Jun 17th 2007

set xl "x / cm"
set yl "y / cm"
set zl "z / cm"

tmp=50
set xr [-tmp:tmp]
set yr [-tmp:tmp]
set zr [0:2*tmp]

set ticslevel 0
set grid front
set nokey
set size 0.66,1

load "KULISA.lab"

sp "KULISA.out" u 1:2:3 w l,\
   "<awk '!/^#/{ i++; }(i==3)' KULISA.out" u 1:2:3 w p lw 3 ps 2
pa -1

call "png.plt" "KULISA.png"

########################################################################

set autoscale xy
set nolabel
set size 1,1
set size ratio -1

p "KULISA_2d.out" u 1:2 w filledcurves,\
  "<awk '!/^#/{ i++; }(i==3)' KULISA_2d.out" u 1:2 w p lw 3 ps 2
pa -1

call "png.plt" "KULISA_2d.png"


