#!/usr/bin/gnuplot

# Vykresleni ciselniku slunecnich hodin (z datovych soboru programu sh)
# Miroslav Broz (miroslav.broz@email.cz), Jan 2nd 2005

# Vykresleni zmenseneho ciselniku s popisky v PostScriptu, EPS a PNG.

reset

set term postscript landscape enhanced fontfile add "Luxi.pfa" "Times"
set out "shc_KULISA.ps"

set xl "{/Times-Oblique X} / cm"
set yl "{/Times-Oblique Y} / cm"

load "ciselnik.plt"
set size ratio -1

load "popisky.plt"

#set xtics 100
#set ytics 100
set mxtics 10
set mytics 10
#set grid
set zeroaxis
set nokey

set style line  1 lt 1
set style line  2 lt 2
set style line  3 lt 3 pt 1 lw 2
set style line  4 lt 1 lw 3 pt 7
set style line  5 lt 5 lw 2
set style line  6 lt 4
set style line  7 lt 6
set style line  8 lt 1
set style line  9 lt 1
set style line 10 lt 3
set style line 11 lt 7
set style line 12 lt 8

set style line 13 lt 1 lw 2	# KULISA

p "horiz_rysky.dat"    u 1:2 w l  ls  8,\
  "vyska_prumet.dat"   u 3:4 w l  ls 12,\
  "azimut_rysky.dat"   u 2:3 w l  ls 11,\
  "zapad_rysky.dat"    u 2:3 w l  ls  7,\
  "vychod_rysky.dat"   u 2:3 w l  ls  6,\
  "temporal_rysky.dat" u 2:3 w l  ls 10,\
  "analema_prumet.dat" u 4:5 w l  ls  9,\
  "datum_prumet.dat"   u 4:5 w l  ls  1,\
  "hodin_rysky.dat"    u 2:3 w l  ls  2,\
  "hodin_prumet.dat"   u 4:5 w p  ls  3,\
  "nodus.dat"          u 1:2 w lp ls  4,\
  "nodus.dat"          u 3:2 w l  ls  5,\
  "KULISA.out"         u 1:2 w l  ls  13

########################################################################

set term postscript eps enhanced fontfile add "Luxi.pfa" "Times"
set out "shc_KULISA.eps"

rep

########################################################################

set term png small xffffff x000000 x000000 xff0000 x0000ee xeecc00 xff0000 xaa00aa xeeee00 x00eeee x000000 xff6633 x666666 x008888 x22aa00
set out "shc_KULISA.png"

set size 1.2,1.2

set xl "X / cm"
set yl "Y / cm"

set style line  1 lt 1
set style line  2 lt 2
set style line  3 lt 3 pt 7
set style line  4 lt 4 lw 3 pt 7 ps 1.5
set style line  5 lt 5 lw 2
set style line  6 lt 6
set style line  7 lt 7
set style line  8 lt 8
set style line  9 lt 9
set style line 10 lt 10
set style line 11 lt 11
set style line 12 lt 12

rep

########################################################################

set size 1,1

# used by sh_*.plt
pi=-1

########################################################################

# Kresleni hodin Gnuplotem na terminalu XWindow
# Miroslav Broz (miroslav.broz@email.cz), Jan 17th 2005

# dirty trick with already defined pi variable!
if (pi>0) load "sh.plt"

load "popisky.plt"

set style line  1 lt 8
set style line  2 lt 3
set style line  3 lt 15 pt 13 ps 1.25
set style line  4 lt 1 lw 3 pt 7 ps 1.75
set style line  5 lt 4
set style line  6 lt 7
set style line  7 lt 6
set style line  8 lt -1
set style line  9 lt 1
set style line 10 lt 5
set style line 11 lt 1
set style line 12 lt 4

set term x11
set out
rep
#pause -1 "Stiskni Enter pro konec"

########################################################################


