#!/usr/bin/awk -f

# pracovni_doba.awk
# Vypocet pracovni doby SH z vystupu programu SHC (datum_prumet.dat).
# Miroslav Broz (miroslav.broz@email.cz), Jun 17th 2007

BEGIN{
  eps=1e-3;
}
/# l = /{
  l = int($4+eps);

# datumy z knihy "SH na pevnych stanovistich", str. 264, tab. 31

  if (l==90) {
    datum1 = " 6/21";
    datum2 = "";
  } else if (l==120) {
    datum1 = " 7/23";
    datum2 = " 5/21";
  } else if (l==150) {
    datum1 = " 8/23";
    datum2 = " 4/20";
  } else if (l==180) {
    datum1 = " 9/23";
    datum2 = " 3/21";
  } else if (l==210) {
    datum1 = "10/23";
    datum2 = " 2/19";
  } else if (l==240) {
    datum1 = "11/22";
    datum2 = " 1/20";
  } else {
    datum1 = "12/22";
    datum2 = "";
  }
  print "";
}
!/^#/ && (NF>1){

# zde zadna podminka neni, proste vypis datum...
  print $1, datum1; 
  if (length(datum2)>0) {
    print $1, datum2;
  }
}


