#!/usr/bin/gnuplot

set xl "hodiny behem dne"
set xr [0:24]
set xtics 2
set mxtics 2
set grid xtics noytics

set yl "dny v roce"
set ydata time
set timefmt "%m/%d"
set format y "%m/%d"
d=24*3600
set yr [0:366*d]
set ytics 30*d
#set autoscale xy

jarni_rovnodennost	=  80*d
letni_slunovrat		= 172*d
podzimni_rovnodennost	= 266*d 
zimni_slunovrat		= 356*d

set label " jarni rovnodennost"		at 24, jarni_rovnodennost	left
set label " letni slunovrat"		at 24, letni_slunovrat		left
set label " podzimni rovnodennost"	at 24, podzimni_rovnodennost	left
set label " zimni slunovrat"		at 24, zimni_slunovrat		left

set style line 1 lt 1 pt 1
set style line 2 lt 7

p "hline.dat" u ($1*24):(jarni_rovnodennost	) not w l ls 2,\
  "hline.dat" u ($1*24):(letni_slunovrat	) not w l ls 2,\
  "hline.dat" u ($1*24):(podzimni_rovnodennost	) not w l ls 2,\
  "hline.dat" u ($1*24):(zimni_slunovrat	) not w l ls 2,\
  "pracovni_doba.out" u 1:2 w p ls 1

pa -1

