#!/usr/bin/gnuplot

set term x11 enh
set encoding iso_8859_2

set xl "hodiny bhem dne"
set xr [0:24]
set xtics 2
set mxtics 2
set grid xtics noytics

set yl "dny v roce"
set ydata time
set timefmt "%m/%d"
set format y "%m/%d"
d=24*3600
set yr [0:366*d]
set ytics 30*d
#set autoscale xy

jarni_rovnodennost	=  80*d
letni_slunovrat		= 172*d
podzimni_rovnodennost	= 266*d 
zimni_slunovrat		= 356*d

set label " {/Helvetica-Bold=10 jarn rovnodennost}"	at 24, jarni_rovnodennost
set label " {/Helvetica-Bold=10 letn slunovrat}"		at 24, letni_slunovrat
set label " {/Helvetica-Bold=10 podzimn rovnodennost}"	at 24, podzimni_rovnodennost
set label " {/Helvetica-Bold=10 zimn slunovrat}"		at 24, zimni_slunovrat

set label " leden"	at 24, 1*d
set label " nor"	at 24, 32*d
set label " bezen"	at 24, 60*d
set label " duben"	at 24, 91*d
set label " kvten"	at 24, 121*d
set label " erven"	at 24, 152*d
set label " ervenec"	at 24, 182*d
set label " srpen"	at 24, 213*d
set label " z"	at 24, 244*d
set label " jen"	at 24, 274*d
set label " listopad"	at 24, 305*d
set label " prosinec"	at 24, 335*d

set style line 1 lt 8 pt 5 ps 1.5
set style line 2 lt 1
set style line 3 lt 7 pt 2 lw 2
set style line 4 lt 3 pt 6 lw 2

set key graph 0.925, graph 0.94 spacing 1.3
set size 0.9,1

p "hline.dat" u ($1*24):(jarni_rovnodennost	) not w l ls 2,\
  "hline.dat" u ($1*24):(letni_slunovrat	) not w l ls 2,\
  "hline.dat" u ($1*24):(podzimni_rovnodennost	) not w l ls 2,\
  "hline.dat" u ($1*24):(zimni_slunovrat	) not w l ls 2,\
  "pracovni_doba.out" u 1:2 t "pracovn doba" w p ls 1,\
  "../stineni_J/stineni_J.out" u 1:2 t "stnn od J" w p ls 3,\
  "../stineni_V/stineni_V.out" u 1:2 t "stnn od V" w p ls 4

#pa -1

#set term png small
#set out "pracovni_doba_stineni.png"
#rep

set term post eps enh color solid "Helvetica" 14
set out "pracovni_doba_stineni.eps"
rep





