#!/usr/bin/awk -f

# stineni_V.awk
# Vypocet stineni SH od prekazky kolme k rovine ciselniku.
# Miroslav Broz (miroslav.broz@email.cz), Jun 17th 2007

BEGIN{
  CISELNIK = "ciselnik.dat"
  getline <CISELNIK;
  getline <CISELNIK;

  x0 = $1;
  y0 = $2;
  print "# Vypocet stineni SH od prekazky kolme k rovine ciselniku."
  print "# x0 = " x0 " cm";
  print "# y0 = " y0 " cm";

  eps=1e-3;
}
/# l = /{
  l = int($4+eps);

# datumy z knihy "SH na pevnych stanovistich", str. 264, tab. 31

  if (l==90) {
    datum1 = " 6/21";
    datum2 = "";
  } else if (l==120) {
    datum1 = " 7/23";
    datum2 = " 5/21";
  } else if (l==150) {
    datum1 = " 8/23";
    datum2 = " 4/20";
  } else if (l==180) {
    datum1 = " 9/23";
    datum2 = " 3/21";
  } else if (l==210) {
    datum1 = "10/23";
    datum2 = " 2/19";
  } else if (l==240) {
    datum1 = "11/22";
    datum2 = " 1/20";
  } else {
    datum1 = "12/22";
    datum2 = "";
  }
  print "";
}
!/^#/ && (NF>1){

# podminka pro stineni z V strany:
  h = $1;
  x = $4;
  y = $5;
  a = y/x;	# rce y = a*x
  if ((y0 < a*x0) && (a>0.)) {
    print h, datum1, l;
    if (length(datum2)>0) {
      print h, datum2, l;
    }
  }
}



