#!/usr/bin/awk -f

# casova_rce_zem_delka.awk
# Spocte korekcni tabulku pro SH (ze sunah.out).
# Miroslav Broz (miroslav.broz@email.cz), Jul 17th 2007

BEGIN{
  split("I II III IV V VI VII VIII IX X XI XII", m);

  print "# datum [MM/DD] & den v roce [] & korekce casu slunecnich hodin (-E + Delta lambda) [min:s] & korekce [min]"

  mp0 = "casova_rce_zem_delka0_.mp";
  mp1 = "casova_rce_zem_delka1_.mp";
  mp2 = "casova_rce_zem_delka2_.mp";
  html = "casova_rce_zem_delka.html";

  print "verbatimtex \\input mbmac etex;" >mp1;
  print "verbatimtex \\input mbmac etex;" >mp2;
}
/# phi = /{
  phi = $4;
  phitex = ddmtex(phi);
}
/# lambda = /{
  lambda = $4;
  lambdatex = ddmtex(lambda);
  print "# phi = " phi "; lambda = " lambda;
  print "v0:=btex $\\varphi = " phitex ", \\lambda = " lambdatex "$ etex;" >mp0;
  
}
!/^#/{
  n++;
}
!/^#/{
  t = $11;
  if (t > 180.) { t = t - 360.; }
  t = -1.*t;		# kdyz ma Slunce v poledne hodinovy uhel > 0, ukazuji SH vic a musim tedy od PMSC ODECITAT
  t = t/360.*24.*60.;	# uhlove stupne -> casove minuty
  ttmp = t;

  sig = plusminus(ttmp);
  ttmp = abs(ttmp);
  min = int(ttmp);
  sec = int((ttmp-min)*60.+0.5)

  mon = $3;
  day = $4;

  print mon "/" day "	" n "	" sig min ":" sec "	" sprintf("%10.5f", t);	# stdout
  print "s(" n ", " sprintf("%8.3f", t) ", btex " day ".\\," m[mon] ". etex, " day ", " mon ");" >mp1;
}
(day==1) || (day==10) || (day==20) || (day==30){

  if (length(day) < 2) { day = " " day; }
  if (length(sec) < 2) { sec = " " sec; }
  min = sig min;
  if (length(min) < 3) { min = " " min; }

  ttmp = t;
  sig = plusminus(ttmp);
  ttmp = abs(ttmp);
  min = int(ttmp+0.5);
  if (min==0) { sig = ""; }

  print "s(" mon ", " day ", " sig min ", btex $\\c{" sig "}" min "$ etex);" >mp2;

  x[mon day] = sig min;
}
END{
  print "<table cellpadding=\"4\" cellspacing=\"0\" border>\n<tr>\n<td></td>\n<td></td>\n<td align=\"center\" colspan=\"12\">měsíc v&nbsp;roce</td>\n</tr>\n<tr>\n<td></td>\n<td></td>" >html;
  for (i=1; i<=12; i++) {
    print "<td align=\"center\">" m[i] ".</td>" >html;
  }
  print "</tr>" >html;
  print "<tr>\n<td rowspan=\"4\">den v&nbsp;měsíci</td>" >html;
  split(" 1,10,20,30", k, ","); 
  for (j=1; j<=4; j++) {
    if (j>1) {
      print "<tr>\n" >html;
    }
    print "<td align=\"right\" width=\"30\">" k[j] ".</td>" >html;
    for (i=1; i<=12; i++) {
      if (x[i k[j]]=="0") {
        tmp=" bgcolor=\"#aaaaaa\"";
      } else {
        tmp="";
      }
      print "<td align=\"center\"" tmp " width=\"30\">" x[i k[j]] "</td>" >html;
    }
    print "</tr>" >html;
  }
  print "</table>" >html;
}


func abs(x) {
  if (x >= 0.) {
    return x;
  } else {
    return -x;
  }
}

func plusminus(x) {
  if (x >= 0.) {
    return "+";
  } else {
    return "-";
  }
}

func pad(s,n, t,i) {
  t = "";
  for (i = length(s); i <= n; i++) {
    t = t " ";
  }
  t = s t;
  return t;
}

func ddmtex(d_, d,m) {
  d = int(d_);
  m = int((d_-d)*60.+0.5);
  return d "^\\circ\\," m "'";
}

