#!/usr/bin/gnuplot

set term png small
set out "casova_rce_zem_delka.png"

set size 0.901,0.7

set xl "datum [DD.MM.]"
set yl "korekce casu slunecnich hodin (-E + Delta lambda) [min]" 0,-2

x1=1
x2=366
set xr [x1:x2]
set xtics nomirror
set ytics 5
set mytics 5
set xtics (\
  "1.I."      1,\
  "1.II."    32,\
  "1.III."   61,\
  "1.IV."    92,\
  "1.V."    122,\
  "1.VI."   153,\
  "1.VII."  183,\
  "1.VIII." 214,\
  "1.IX."   245,\
  "1.X."    275,\
  "1.XI."   306,\
  "1.XII."  336,\
  "1.I."    366 \
)
set grid xtics ytics

set nokey

set style line 1 lt 1 lw 3
set style line 2 lt 7

p "casova_rce_zem_delka.dat" u 2:4 w l ls 1,\
  "<echo \"0 1\n 1 1\"" u (x1+$1*(x2-x1)):($2*0) w l ls 2


