#!/usr/bin/awk -f

# popisky.awk
# Prevod popisku v TXT do PostScriptu (pro vyrezani na plotteru).
# Miroslav Broz (miroslav.broz@email.cz), Oct 15th 2002

# Pouziti: popisky.awk < popisky.txt > popisky.ps

BEGIN{

# fonty pro popisky (v Symbolu je znak stupne)
  FONT1 = "Times-Bold";
  FONT2 = "Symbol";

# zakladni velikost pisma
  SIZE1 = 72;

  SIZE2 = 42/72*SIZE1;	# exponent
  SHIFT = 28/72*SIZE1;

  print "%!";

  print "/M {moveto} def";
  print "/R {rmoveto} def";
  print "/S {show} def";
  print "/F {/" FONT1 " findfont " SIZE1 " scalefont setfont} def";
  print "/FS {/" FONT2 " findfont " SIZE1 " scalefont setfont} def";
  print "/FE {/" FONT1 " findfont " SIZE2 " scalefont setfont} def";
  print "/E {FE 0 " SHIFT " R S 0 " 0-SHIFT " R F} def";

  print "0 0 M\nF";

  i = 0;
  n = 0;
  i1st = 1;
}
(NF==0) && (n > 0){
  i++;
  print "0 " i*SIZE1 " M";
  n = 0;
}
!/^#/ && (NF>0){
  n++;
  j = index($1,"");
  if (j > 0) {
    print "(" substr($1,0,j-1) ") S";
    print "FS () S F";
  } else {
    j = split($1,a,":");
    print "(" a[1] ") S";
    if (j > 1) {
      print "(" a[2] ") E";
    }
  }
}
END{
  print "showpage\n%%EOF";
}

