<?php

# shc.php
# Jednoduche WWW rozhrani pro navrh ciselniku (SHC).
# Miroslav Broz (miroslav.broz@email.cz)

$version_cz = "20. 3. 2022";
$admin = "miroslav.broz@email.cz";
$url = "http://astro.troja.mff.cuni.cz/mira/shc/shc.php";
$cgi_file = "./shc.php";
$katalog = "http://astro.troja.mff.cuni.cz/mira/sh/sh.php";

$languages = array(
  'cz' => "Česky",
  'gb' => "English"
);

$version_cz = preg_replace("/ /", "&nbsp;", $version_cz);

#ob_start(); # switch output buffering on! (it improves performance greatly)

########################################################################

# pass variables

$QUERY_STRING = $_SERVER["QUERY_STRING"];

$submit		= $_GET["submit"];
$type		= $_GET["type"];
$image		= $_GET["image"];
$lang		= $_GET["lang"];

$phi		= $_GET["phi"];
$lambda		= $_GET["lambda"];
$az		= $_GET["az"];
$ht		= $_GET["ht"];
$x1		= $_GET["x1"];
$y1		= $_GET["y1"];
$x2		= $_GET["x2"];
$y2		= $_GET["y2"];
$d_nodus	= $_GET["d_nodus"];
$dt		= $_GET["dt"];
$dvz		= $_GET["dvz"];
$dd		= $_GET["dd"];
$daz		= $_GET["daz"];
$dht		= $_GET["dht"];
$dah		= $_GET["dah"];
$ndate		= $_GET["ndate"];
$gnomon		= $_GET["gnomon"];
$t_horiz	= $_GET["t_horiz"];
$t_hodin	= $_GET["t_hodin"];
$t_SEC		= $_GET["t_SEC"];
$t_letni	= $_GET["t_letni"];
$t_prodluz	= $_GET["t_prodluz"];
$t_delkadne	= $_GET["t_delkadne"];
$t_vychod	= $_GET["t_vychod"];
$t_zapad	= $_GET["t_zapad"];
$t_temporal	= $_GET["t_temporal"];
$t_analema	= $_GET["t_analema"];
$cast_analemy	= $_GET["cast_analemy"];
$t_azimut	= $_GET["t_azimut"];
$t_vyska	= $_GET["t_vyska"];
$t_date1        = $_GET["t_date1"];
$l_date1        = $_GET["l_date1"];

$datum		= $_GET["datum"];
$time		= $_GET["time"];
$nsteps		= $_GET["nsteps"];
$precession	= $_GET["precession"];
$nutation	= $_GET["nutation"];
$refraction	= $_GET["refraction"];

########################################################################

# log EVERYTHING

#error_reporting(E_ERROR); # error handling

$log_file = "./shc.log";
$id = fopen($log_file, "a");
if (!$id)
  err_msg("Chyba při otevírání log-souboru `$log_file'.");

$date = date("Y/m/d H:i:s");
if (sizeof($_POST) > 0) {
  $POST_VARS = " _POST";
  while (list($key, $val) = each($_POST))
     $POST_VARS .= "\n  $key: $val";
} else
  $POST_VARS = "";
$out = "$date " . gethostbyaddr($_SERVER["REMOTE_ADDR"]) . " " . $_SERVER["REMOTE_ADDR"] . " $cgi_file?$QUERY_STRING$POST_VARS\n";
fwrite($id, $out);
fclose($id);

########################################################################

# laguage dependent messages

if ($lang == "") $lang = 'cz'; # default language

$msg_file = "./shc.msg";
$id = fopen($msg_file, "r");
if (!$id)
  err_msg("Chyba při otevírání msg-souboru `$msg_file'.");

$in = fread($id, filesize($msg_file));
fclose($id);

$i = 0;
foreach (explode("\n", $in) as $l) {
  $i++;
  if (strlen($l) == 0) {
    $i = 0;
    reset($languages);
  }
  if ($i == 1)
    $key = $l;
  else if ($i > 1) {
    $msg[key($languages)][$key] = $l;
    next($languages);
  }
}

########################################################################

# header/footer/menu

$header = '<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-type" content="text/html; charset=utf-8">
<meta name="keywords" lang="cs" content="slunecni, sluneční, hodiny, číselník, návrh">
<meta name="keywords" lang="sk" content="slnecne, slnečné, hodiny, ciferník, návrh">
<meta name="keywords" lang="en" content="sundial, sundials, design">
<meta name="keywords" lang="de" content="sonnenuhr, sonnenuhren">
<meta name="keywords" lang="fr" content="cadran, cadrans, solaires">
<meta name="description" lang="cs" content="Sluneční hodiny - návrh číselníku">
<meta name="description" lang="sk" content="Slnečné hodiny - návrh ciferníka">
<meta name="description" lang="en" content="Sundials">
<meta name="description" lang="de" content="Sonnenuhren">
<meta name="description" lang="fr" content="Cadrans solaires">
<title>' . $msg[$lang]['title'] . '</title>
</head>

<body bgcolor="#cccccc" text="#000000" link="#0000ee" vlink="#000088" alink="#000000">
<img src="shc.jpg" align="right" alt="' . $msg[$lang]['shc.jpg'] . '">
<h1>' . $msg[$lang]['title'] . '</h1>

';

$footer = "

<p><hr>
<small>
&copy;
<a href=\"mailto:$admin\">Miroslav Brož</a>
-
<a href=\"$url\"><code>$url</code></a>;
" . $msg[$lang]['verze'] . " $version_cz
</small>
<hr>

</body>
</html>
";

$lang_menu = "";
for (reset($languages); $key = key($languages); next($languages)) {
  $lang_menu .= "| <a href=\"$cgi_file?lang=$key\"><img src=\"icons/$key.gif\" border=\"0\"></a>&nbsp;<a href=\"$cgi_file?lang=$key\">" . $languages[$key] . "</a>\n";
}
$lang_menu = substr($lang_menu, 0, strlen($lang_menu)-1);

if ((strlen($phi)>0) && (strlen($lambda)>0))
  $ephem_url = "&phi=" . urlencode($phi) . "&lambda=" . urlencode($lambda);
else
  $ephem_url = "";

$menu = "
[&nbsp;<a href=\"$cgi_file?lang=$lang$ephem_url\">" . $msg[$lang]['navrh'] . "</a>
| <a href=\"$cgi_file?type=ephem&lang=$lang$ephem_url\">" . $msg[$lang]['ephem'] . "</a>
| <a href=\"$cgi_file?type=casova_rce_zem_delka&lang=$lang$ephem_url\">" . $msg[$lang]['casova_rce_zem_delka'] . "</a>
| <a href=\"$cgi_file?type=help&lang=$lang\">" . $msg[$lang]['help'] . "</a>
| <a href=\"$cgi_file?type=download&lang=$lang\">" . $msg[$lang]['download'] . "</a>
| <a href=\"../sha/sha.php\">SHA</a> (" . $msg[$lang]['sha'] . ")
| <a href=\"$katalog\">" . $msg[$lang]['sh.php'] . "</a>
$lang_menu&nbsp;]

<hr>
";

########################################################################

// main program

if ((!strcmp($submit, $msg[$lang]['odeslat'])) && (!strcmp($type, "casova_rce_zem_delka"))) { casova_rce_zem_delka(); }
else if (!strcmp($submit, $msg[$lang]['odeslat'])) { shc(); }
else if (!strcmp($submit, $msg[$lang]['spocitat'])) { sunah(); }
else if (!strcmp($type, "ephem")) { sunah_form(); }
else if (!strcmp($type, "download")) { download(); }
else if (!strcmp($type, "help")) { print_help(); }
else if (!strcmp($type, "shcdat")) { print_shcdat(); }
else if (!strcmp($type, "getshc")) { get_shc_file(); }
else if (!strcmp($type, "casova_rce_zem_delka")) { casova_rce_zem_delka_form(); }
else { print_form(); }

exit;

########################################################################

function err_msg($message) {
  global $header, $footer, $menu, $admin;

  echo "$header
$menu

<p><font color=\"red\">$message</font>
<p>Kontaktujte prosím <a href=\"mailto:$admin\">administrátora</a>.\n
$footer
";
  exit;
}

########################################################################

function default_values() {
  global $QUERY_STRING;

# form vars
  global $phi, $lambda, $az, $ht, $x1, $y1, $x2, $y2, $d_nodus,
    $dt, $dvz, $dd, $daz, $dht, $dah, $ndate, $gnomon, $t_horiz, $t_hodin, $t_SEC, $t_letni,
    $t_prodluz, $t_delkadne, $t_vychod, $t_zapad, $t_temporal,
    $t_analema, $cast_analemy, $t_azimut, $t_vyska, $t_date1, $l_date1;
  global $datum, $time, $nsteps, $precession, $nutation, $refraction;

  $tmp = preg_replace("/\&?(lang|type|phi|lambda)=[a-zA-Z0-9:%]+\&?/", "", $QUERY_STRING);

  if (!isset($phi))	$phi = "50:10:38";
  if (!isset($lambda))	$lambda = "15:50:21";
  if (!isset($az))	$az = 0;
  if (!isset($ht))	$ht = 0;
  if (!isset($x1))	$x1 = -100;
  if (!isset($y1))	$y1 = -150;
  if (!isset($x2))	$x2 = 100;
  if (!isset($y2))	$y2 = 10;
  if (!isset($d_nodus))	$d_nodus = 40;
  if (!isset($dt))	$dt = "1:0:0";
  if (!isset($dvz))	$dvz = "1:0:0";
  if (!isset($dd))	$dd = "0:10:0";
  if (!isset($daz))	$daz = 10;
  if (!isset($dht))	$dht = 10;
  if (!isset($dah))	$dah = 2;
  if (!isset($ndate))	$ndate = 7;
  if (!isset($gnomon))	$gnomon = 0;
  if (!isset($t_horiz))	$t_horiz = 0;
  if (!isset($t_hodin))	$t_hodin = 0;
  if (!isset($t_SEC))	$t_SEC = 0;
  if (!isset($t_letni))	$t_letni = 0;
  if (!isset($t_prodluz))	$t_prodluz = 0;
  if (!isset($t_delkadne))	$t_delkadne = 0;
  if (!isset($t_vychod))	$t_vychod = 0;
  if (!isset($t_zapad))		$t_zapad = 0;
  if (!isset($t_temporal))	$t_temporal = 0;
  if (!isset($t_analema))	$t_analema = 0;
  if (!isset($cast_analemy))	$cast_analemy = 0;
  if (!isset($t_azimut))	$t_azimut = 0;
  if (!isset($t_vyska))		$t_vyska = 0;
  if (!isset($t_date1))		$t_date1 = 0;
  if (!isset($l_date1))		$l_date1 = 0;

# in case of no values in QUERY_STRING:
  if (strlen($tmp) == 0) {
    $t_hodin = 1;
    $t_prodluz = 1;
  }

# sunah
  if (!isset($precession))	$precession = 0;
  if (!isset($nutation))	$nutation = 0;
  if (!isset($refraction))	$refraction = 0;
  if (strlen($tmp) == 0) {
    $precession = 1;
    $nutation = 0;
    $refraction = 1;
  }
  if (!isset($datum))		$datum = date("Y/m/d");
  if (!isset($time))		$time = "0:0:0";
  if (!isset($nsteps))		$nsteps = 25;

# set reasonable limits
  $tmp = 1./3600.;
  if (hmsh($dt)  < $tmp)	$dt  = $tmp;
  if (hmsh($dvz) < $tmp)	$dvz = $tmp;
  if (hmsh($dd)  < $tmp)	$dd  = $tmp;
  if ($daz < 0.1)	$daz = 0.1;
  if ($dht < 1)		$dht = 1;
  if ($dah < 1)		$dah = 1;
  if ((hmsh($dt)  < 1./6.) && ($t_analema == 2)) $dt  = 1./6.; # check number of analemmas

  if ($nsteps > 10000)
    $nsteps = 9999;

# check variables
  $az = preg_replace("/,/", ".", $az);
}

########################################################################

function print_form() {
  global $header, $footer, $menu, $cgi_file, $katalog, $languages, $image, $lang, $msg;

# form vars
  global $phi, $lambda, $az, $ht, $x1, $y1, $x2, $y2, $d_nodus,
    $dt, $dvz, $dd, $daz, $dht, $dah, $ndate, $gnomon, $t_horiz, $t_hodin, $t_SEC, $t_letni,
    $t_prodluz, $t_delkadne, $t_vychod, $t_zapad, $t_temporal,
    $t_analema, $cast_analemy, $t_azimut, $t_vyska, $t_date1, $l_date1;

  default_values();

  $checked = " checked";
  $ndate_select[$ndate] = " selected";
  $gnomon_check[$gnomon] = $checked;
  $t_SEC_check[$t_SEC] = $checked;
  if ($t_horiz == 1) $t_horiz_check = $checked;
  if ($t_hodin == 1) $t_hodin_check = $checked;
  if ($t_letni == 1) $t_letni_check = $checked;
  $t_prodluz_check[$t_prodluz] = $checked;
  if ($t_delkadne == 1) $t_delkadne_check = $checked;
  if ($t_temporal == 1) $t_temporal_check = $checked;
  if ($t_vychod   == 1) $t_vychod_check   = $checked;
  if ($t_zapad    == 1) $t_zapad_check    = $checked;
  if ($t_azimut   == 1) $t_azimut_check   = $checked;
  if ($t_vyska    == 1) $t_vyska_check    = $checked;
  if ($t_date1    == 1) $t_date1_check    = $checked;
  $t_analema_check[$t_analema] = $checked;
  $cast_analemy_check[$cast_analemy] = $checked;

# sundial examples (=> shc files)
  $file = "examples.txt";
  $fd = fopen($file, "r");
  $in = fread($fd, filesize($file));
  fclose($fd);

  $l = explode("\n", $in);
  $n = sizeof($languages) + 3;
  $examples = "";
  for ($i = 0; $i < sizeof($l)-$n; $i += $n) {
    $shc = $l[$i];
    $url = $l[$i+1];
    $j = 0;
    for (reset($languages); $key = key($languages); next($languages)) {
      $j++;
      $desc_lang[$key] = $l[$i+1+$j];
    }
    $desc = $desc_lang[$lang];
    $examples .= "<li><a href=\"$cgi_file?$url&submit=" . urlencode($msg[$lang]['odeslat']) . "&lang=$lang\">$desc";
  }

# sundial models - images and descriptions
  $file = "models.txt";
  $fd = fopen($file, "r");
  $in = fread($fd, filesize($file));
  fclose($fd);

  $l = explode("\n", $in);
  $models = "";
  for ($i = 0; $i < sizeof($l)-6; $i += 6) {
    $adresa = $l[$i];
    $desc = $l[$i+1];
    if (strlen($desc) > 0)
      $desc = "- " . $desc;
    $file = $l[$i+2];
    $evc = $l[$i+3];
    if (strlen($evc) > 0)
      $evc = "<small>(<a href=\"$katalog?search=" . urlencode($evc) . "&field=27&im_feeling_lucky=\">$evc</a>)</small>";
    $url = $l[$i+4];
    $models .= "<tr>
<td><a href=\"$cgi_file?$url&image=$file&submit=" . urlencode($msg[$lang]['odeslat']) . "&lang=$lang\"><img src=\"icons/$file\" border=\"0\"></a></td>
<td width=\"10\"></td>
<td valign=\"top\">$adresa
$evc
$desc
</td>
</tr>
";
  }

# output HTML
  echo "$header
$menu

<h2>" . $msg[$lang]['navrh'] . "</h2>

<p>[&nbsp;<a href=\"$cgi_file?type=help&lang=$lang\">" . $msg[$lang]['help'] . "</a>
| <a href=\"#priklady\">" . $msg[$lang]['priklady'] . "</a>&nbsp;]

<form action=\"$cgi_file\" method=\"get\">

<p>" . $msg[$lang]['phi'] . " <small>[+DD:MM:SS]</small>
<input type=\"text\" size=\"10\" name=\"phi\" value=\"$phi\">

<p>" . $msg[$lang]['lambda'] . " <small>[+DD:MM:SS, " . $msg[$lang]['lonot'] . "]</small>
<input type=\"text\" size=\"10\" name=\"lambda\" value=\"$lambda\">

<p><small>" . $msg[$lang]['viz'] . " <a href=\"$cgi_bin?type=shcdat\">" . $msg[$lang]['shc.dat'] . "</a>
" . $msg[$lang]['databaze'] . "
<a href=\"http://www.heavens-above.com\"><tt>http://www.heavens-above.com</tt></a>.
</small>

<p>" . $msg[$lang]['az'] . "
<input type=\"text\" size=\"5\" name=\"az\" value=\"$az\">
" . $msg[$lang]['ht'] . "
<input type=\"text\" size=\"5\" name=\"ht\" value=\"$ht\">
" . $msg[$lang]['normala'] . " " . $msg[$lang]['deg'] . "

<p>" . $msg[$lang]['x1y1'] . ": x =
<input type=\"text\" size=\"5\" name=\"x1\" value=\"$x1\">
y =
<input type=\"text\" size=\"5\" name=\"y1\" value=\"$y1\">
[cm]

<p>" . $msg[$lang]['x2y2'] . ": x =
<input type=\"text\" size=\"5\" name=\"x2\" value=\"$x2\">
y =
<input type=\"text\" size=\"5\" name=\"y2\" value=\"$y2\">
[cm]

<p>" . $msg[$lang]['d_nodus'] . " [cm]
<input type=\"text\" size=\"5\" name=\"d_nodus\" value=\"$d_nodus\">

<p><small>" . $msg[$lang]['d_nodusnot'] . "</small>

<p>" . $msg[$lang]['dt'] . " <small>[HH:MM:SS]</small>
<input type=\"text\" size=\"10\" name=\"dt\" value=\"$dt\">

<p>" . $msg[$lang]['dvz'] . " <small>[HH:MM:SS]</small>
<input type=\"text\" size=\"10\" name=\"dvz\" value=\"$dvz\">

<p>" . $msg[$lang]['dd'] . " <small>[HH:MM:SS]</small>
<input type=\"text\" size=\"10\" name=\"dd\" value=\"$dd\">

<p>" . $msg[$lang]['kroky'] . ":
" . $msg[$lang]['daz'] . "
<input type=\"text\" size=\"3\" name=\"daz\" value=\"$daz\">

" . $msg[$lang]['dht'] . "
<input type=\"text\" size=\"3\" name=\"dht\" value=\"$dht\">

" . $msg[$lang]['dah'] . "
<input type=\"text\" size=\"3\" name=\"dah\" value=\"$dah\">
" . $msg[$lang]['deg'] . "

<p>" . $msg[$lang]['ndate'] . "
<select name=\"ndate\">
<option value=\"0\"$ndate_select[0]>0</option>
<option value=\"3\"$ndate_select[3]>3</option>
<option value=\"7\"$ndate_select[7]>7</option>
</select>

<p>" . $msg[$lang]['ukazatel'] . ":
<input type=\"radio\" name=\"gnomon\" value=\"0\"$gnomon_check[0]>
" . $msg[$lang]['polos'] . "
<input type=\"radio\" name=\"gnomon\" value=\"1\"$gnomon_check[1]>
" . $msg[$lang]['gnomon'] . "

<p>" . $msg[$lang]['t_horiz'] . "
<input type=\"checkbox\" name=\"t_horiz\" value=\"1\"$t_horiz_check>

<p>" . $msg[$lang]['t_SEC'] . ":
<input type=\"radio\" name=\"t_SEC\" value=\"0\"$t_SEC_check[0]>
" . $msg[$lang]['pravy'] . "
<input type=\"radio\" name=\"t_SEC\" value=\"1\"$t_SEC_check[1]>
" . $msg[$lang]['SEC'] . "

<p>" . $msg[$lang]['t_letni'] . "
<input type=\"checkbox\" name=\"t_letni\" value=\"1\"$t_letni_check>

<p>" . $msg[$lang]['t_prodluz'] . ":
<input type=\"radio\" name=\"t_prodluz\" value=\"0\"$t_prodluz_check[0]>
" . $msg[$lang]['t_prodluz0'] . "
<input type=\"radio\" name=\"t_prodluz\" value=\"1\"$t_prodluz_check[1]>
" . $msg[$lang]['t_prodluz1'] . "
<input type=\"radio\" name=\"t_prodluz\" value=\"2\"$t_prodluz_check[2]>
" . $msg[$lang]['t_prodluz2'] . "
<input type=\"radio\" name=\"t_prodluz\" value=\"3\"$t_prodluz_check[3]>
" . $msg[$lang]['t_prodluz3'] . "

<p>" . $msg[$lang]['t_delkadne'] . "
<input type=\"checkbox\" name=\"t_delkadne\" value=\"1\"$t_delkadne_check>

<p>" . $msg[$lang]['rysky'] . ":
<input type=\"checkbox\" name=\"t_hodin\" value=\"1\"$t_hodin_check>
" . $msg[$lang]['t_hodin'] . "
<input type=\"checkbox\" name=\"t_temporal\" value=\"1\"$t_temporal_check>
" . $msg[$lang]['t_temporal'] . "
<input type=\"checkbox\" name=\"t_vychod\" value=\"1\"$t_vychod_check>
" . $msg[$lang]['t_vychod'] . "
<input type=\"checkbox\" name=\"t_zapad\" value=\"1\"$t_zapad_check>
" . $msg[$lang]['t_zapad'] . "

<p>" . $msg[$lang]['t_analema'] . ":
<input type=\"radio\" name=\"t_analema\" value=\"0\"$t_analema_check[0]>
" . $msg[$lang]['t_analema0'] . "
<input type=\"radio\" name=\"t_analema\" value=\"1\"$t_analema_check[1]>
" . $msg[$lang]['t_analema1'] . "
<input type=\"radio\" name=\"t_analema\" value=\"2\"$t_analema_check[2]>
" . $msg[$lang]['t_analema2'] . "

<p>" . $msg[$lang]['cast_analemy'] . ":
<input type=\"radio\" name=\"cast_analemy\" value=\"0\"$cast_analemy_check[0]>
" . $msg[$lang]['cast_analemy0'] . "
<input type=\"radio\" name=\"cast_analemy\" value=\"1\"$t_analema_check[1]>
" . $msg[$lang]['cast_analemy1'] . "
<input type=\"radio\" name=\"cast_analemy\" value=\"2\"$t_analema_check[2]>
" . $msg[$lang]['cast_analemy2'] . "

<p><input type=\"checkbox\" name=\"t_azimut\" value=\"1\"$t_azimut_check>
" . $msg[$lang]['t_azimut'] . "
<input type=\"checkbox\" name=\"t_vyska\" value=\"1\"$t_vyska_check>
" . $msg[$lang]['t_vyska'] . "

<p><input type=\"checkbox\" name=\"t_date1\" value=\"1\"$t_date1_check>
" . $msg[$lang]['t_date1'] . "
<input type=\"text\" size=\"3\" name=\"l_date1\" value=\"$l_date1\">
" . $msg[$lang]['deg'] . "

<p><input type=\"submit\" name=\"submit\" value=\"" . $msg[$lang]['odeslat'] . "\">
<input type=\"submit\" name=\"ulozit\" value=\"" . $msg[$lang]['ulozit'] . "\">
<input type=\"reset\" value=\"" . $msg[$lang]['smazat'] . "\">
<a href=\"$cgi_file?lang=$lang\">" . $msg[$lang]['standard'] . "</a>

<input type=\"hidden\" name=\"image\" value=\"$image\" >
<input type=\"hidden\" name=\"lang\" value=\"$lang\" >

<p><small>" . $msg[$lang]['ulozit_notice'] . "</small>

</form>

<p><hr>

<a name=\"priklady\"></a>

<h3>" . $msg[$lang]['priklady'] . ":</h3>

<ol>
$examples
</ol>

<p><small>" . $msg[$lang]['priklady_notice'] . "</small>

<a name=\"modely\"></a>

<h3>" . $msg[$lang]['modely'] . ":</h3>

<p><table border=0 cellpadding=2 cellspacing=0>
$models
</table>

<h3>" . $msg[$lang]['dalsi'] . "</h3>

<ol>
<li><a href=\"$katalog?type=catalogue_image&search=%2A+FROM+sh+WHERE+poznamka+%7E+%27programem+SH%28C%7CA%29%27+ORDER+BY+adresa%3B&query=sql\">" . $msg[$lang]['seznam'] . "</a>
<small>(" . $msg[$lang]['odkaz'] . ")</small>

<li><a href=\"$katalog?type=catalogue_image&search=%2A+FROM+sh+WHERE+obrazky+%7E+%27%5C.%28shc%7Csha%29%27+ORDER+BY+adresa%3B&query=sql\">" . $msg[$lang]['seznam2'] . "</a>

<li><a href=\"advanced/\">" . $msg[$lang]['advanced'] . "</a>
<small>(" . $msg[$lang]['advanced2'] . ")</small>

<li>" . $msg[$lang]['sources'] . "
</ol>

$footer
";

 return 0;
}

########################################################################

function download() {
  global $header, $footer, $menu, $cgi_file, $lang, $msg;

  $in = shell_exec("ls -lLh download/shc*");
  $l = explode("\n", $in);
  $files = "";
  $j = strpos($l[0], "download");
  for ($i = 0; $i < sizeof($l)-1; $i++)
    $files .= substr($l[$i], 0, $j) . " <a href=\"" . substr($l[$i],$j) . "\">" . substr($l[$i],$j+9) . "</a>\n";
  $files = substr($files, 0, strlen($files)-1);

  echo "$header
$menu

<h2>" . $msg[$lang]['download'] . "</h2>

<p>" . $msg[$lang]['download_help'] . ":

<pre>$files</pre>

$footer
";

}

########################################################################

function shc() {
  global $header, $footer, $menu, $cgi_file, $QUERY_STRING, $image, $lang, $msg;

# form vars
  global $phi, $lambda, $az, $ht, $x1, $y1, $x2, $y2, $d_nodus,
    $dt, $dvz, $dd, $daz, $dht, $dah, $ndate, $gnomon, $t_horiz, $t_hodin, $t_SEC, $t_letni,
    $t_prodluz, $t_delkadne, $t_vychod, $t_zapad, $t_temporal,
    $t_analema, $cast_analemy, $t_azimut, $t_vyska, $t_date1, $l_date1;

# data files
  $data_file = array(
    "analema_prumet.dat",
    "azimut_prumet.dat",
    "azimut_rysky.dat",
    "ciselnik.dat",
    "*datum_prumet.dat",
    "hodin_prumet.dat",
    "*hodin_rysky.dat",
    "horiz_rysky.dat",
    "korekce.dat",
    "nodus.dat",
    "popisky.dat",
    "temporal_prumet.dat",
    "temporal_rysky.dat",
    "vychod_prumet.dat",
    "vychod_rysky.dat",
    "vyska_prumet.dat",
    "zapad_prumet.dat",
    "zapad_rysky.dat",
    "",
    "shc.png",
    "*shc.pdf",
    "shc.ps",
    "shc.eps",
    "shc_A4.ps",
    "shc.ai",
    "popisky.pdf",
    "popisky.ps",
    "popisky.ai",
    "popisky_krivky.ps",
    "",
    "shc.in",
    "shc.out",
    "shc.shc",
    "shc.zip"
  );

  default_values();

# create a writable temporary directory
  $rnd = rand();
  shell_exec("mkdir tmp/$rnd");

# create an input file for shcnox
  $fd = fopen("tmp/$rnd/shc.in", "w");
  $out = "$phi	/* zeměpisná šířka (phi) stanoviště [+DD:MM:SS] */
$lambda	/* zeměpisná délka (lambda) stanoviště [+DD:MM:SS, kladně na V] */
$az $ht		/* azimut a výška normály ke stěně [deg] */
$x1 $y1	/* levý dolní roh číselníku x, y [cm] *
$x2 $y2		/* pravý horní roh číselníku x, y [cm] */
$d_nodus		/* vzdálenost nodu od paty ukazatele (délka ukazatele) [cm]; záporná hodnota značí u vertikálních hodin směr k S světovému pólu ; pro gnómon vzdálenost od roviny číselníku */
$dt		/* interval hodinových rysek dt [HH:MM:SS] */
$dvz		/* interval hodin od východu/západu slunce dvz [HH:MM:SS] */
$dd		/* interval datových čar dd [HH:MM:SS] */
$daz		/* interval azimutálních úseček daz [deg] */
$dht		/* interval výškových křivek dht [deg] */
$dah		/* krok pro výpočet výškových křivek dah [deg] */
$ndate		/* počet datových čar (0, 3 nebo 7) */
$gnomon		/* polos nebo gnómon? [0|1] */
$t_horiz		/* zobrazit i neskutečné čáry pod horizontem? [0|1] */
$t_hodin		/* zobrazovat hodinové rysky? [0|1] */
$t_SEC		/* pravý sluneční čas nebo korigovaný o délku lambda na SEČ? [0|1] */
$t_letni		/* \"zimní\" nebo letní čas? [0|1] */
$t_prodluz		/* prodloužení rysek: žádné, k patě polosu, k okraji číselníku, oboje? [0|1|2|3] */
$t_delkadne		/* datové čáry pro celočíselné délky trvání dne? [0|1] */
$t_vychod		/* počítat rysky od východu slunce? [0|1] */
$t_zapad		/* počítat rysky od západu slunce předchozího dne? [0|1] */
$t_temporal		/* rysky temporálních hodin? [0|1] */
$t_analema		/* počítat analemu, pro 12 h nebo všechny hodinové rysky? [0|1|2] */
$cast_analemy		/* celá, letní nebo zimní část analemy? [0|1|2] */
$t_azimut		/* azimutální úsečky? [0|1] */
$t_vyska		/* výškové křivky? [0|1] */
$t_date1		/* dodatečná datová křivka? [0|1] */
$l_date1		/* ekliptikální délka slunce [deg] */
";
  fwrite($fd, $out);
  fclose($fd);

  shell_exec("./shc.sh tmp/$rnd");

# create a config file for SHC
  $fd = fopen("tmp/$rnd/shc.shc", "w");
  $out = get_shc_contents();
  fwrite($fd, $out);
  fclose($fd);

# link back to form
  $url = preg_replace("/". urlencode($msg[$lang]['odeslat']) . "/", "", $QUERY_STRING);

# link to casova_rce_zem_delka
  $casova_rce_zem_delka_url = "phi=" . urlencode($phi) . "&lambda=" . urlencode($lambda) . "&submit=" . urlencode($msg[$lang]['odeslat']);

# image below dial scheme
  if (strlen($image) > 0)
    $image = "<p>" . $msg[$lang]['fotografie'] . ":\n\n<p><img src=\"images/$image\" alt=\"fotografie\">";

# data files
  $data = data_table($data_file, $rnd);

  echo "$header
$menu

<p>[&nbsp;<a href=\"$cgi_file?$url\">" . $msg[$lang]['upravit'] . "</a>
| <a href=\"$cgi_file?lang=$lang\">" . $msg[$lang]['novy'] . "</a>
| <a href=\"$cgi_file?type=casova_rce_zem_delka&$casova_rce_zem_delka_url\">" . $msg[$lang]['casova_rce_zem_delka'] . "</a>&nbsp;]

<p>" . $msg[$lang]['obrazek'] . ":
<p><img src=\"tmp/$rnd/shc.png\" alt=\"shc.png\">

<p><table cellpadding=\"0\" cellspacing=0 border=0>
<tr>
<td valign=\"top\">" . $msg[$lang]['legenda'] . ":&nbsp;</td>
<td valign=\"top\"><img src=\"legenda_$lang.png\" alt=\"legenda.png\"></td>
</tr>
</table>

$image

<p>" . $msg[$lang]['data'] . ":

<p><table border=\"0\" cellpadding=\"2\" cellspacing=\"0\">
$data
</table>

$footer
";

 return 0;

}

########################################################################

function get_shc_contents() {

# form vars
  global $phi, $lambda, $az, $ht, $x1, $y1, $x2, $y2, $d_nodus,
    $dt, $dvz, $dd, $daz, $dht, $dah, $ndate, $gnomon, $t_horiz, $t_hodin, $t_SEC, $t_letni,
    $t_prodluz, $t_delkadne, $t_vychod, $t_zapad, $t_temporal,
    $t_analema, $cast_analemy, $t_azimut, $t_vyska, $t_date1, $l_date1;

  return "# shc config file (generated by shc.php)
# parameters: phi lambda az ht x1 y1 x2 y2 d_nodus dt dvz dd daz dht dah ndate gnomon t_horiz t_hodin t_SEC t_letni t_prodluz t_delkadne t_vychod t_zapad t_temporal t_analema cast_analemy t_azimut t_vyska t_date1 l_date1
$phi
$lambda
$az $ht
$x1 $y1
$x2 $y2
$d_nodus
$dt
$dvz
$dd
$daz
$dht
$dah
$ndate
$gnomon
$t_horiz
$t_hodin
$t_SEC
$t_letni
$t_prodluz
$t_delkadne
$t_vychod
$t_zapad
$t_temporal
$t_analema
$cast_analemy
$t_azimut
$t_vyska
$t_date1
$l_date1
";
}

########################################################################

function data_table($data_file, $rnd) {

  global $msg, $lang;

  $data = "";
  for ($i = 0; $i < sizeof($data_file); $i++)
    if (strlen($data_file[$i]) > 0) {
      if (preg_match("/^\*.*/", $data_file[$i])) {
        $data_file[$i] = preg_replace("/^\*/", "", $data_file[$i]);
        $tmp = " bgcolor=\"#aaaaaa\"";
      } else
        $tmp = "";

      $data .= "<tr$tmp>
<td valign=\"top\"><a href=\"tmp/$rnd/$data_file[$i]\"><code>$data_file[$i]</code></a></td>
<td>" . $msg[$lang][$data_file[$i]] . "</td>
<tr>
";
    } else
      $data .= "<tr><td colspan=\"2\"></td></tr>";

  return $data;
}

########################################################################

function print_help() {
  global $header, $footer, $menu, $cgi_file, $lang, $msg;

  $file = "README." . $lang;
  $fd = fopen($file, "r");
  $readme = fread($fd, filesize($file));
  fclose($fd);

  $readme = preg_replace("/(http:\/\/[a-zA-Z0-9\.\/\~_\-]*[a-zA-Z0-9])/","<a href=\"\\1\">\\1</a>", $readme);
  $readme = preg_replace("/(doc\/[a-z_]*\.[a-z]*)/","<a href=\"\\1\">\\1</a>", $readme);

  echo "$header
$menu

<h2>" . $msg[$lang]['help'] . "</h2>

<pre>
$readme</pre>

$footer
";

}

########################################################################

function print_shcdat() {
  global $header, $footer, $menu, $cgi_file, $lang, $msg;

  $file = "shc.dat";
  $fd = fopen($file, "r");
  $in = fread($fd, filesize($file));
  fclose($fd);

  echo "$header
$menu

<p>" . $msg[$lang]['seznam_stanovist'] . " <small>(" . $msg[$lang]['soubor'] . " <a href=\"shc.dat\"><code>shc.dat</code></a>)</small>:


<pre>
# stanoviště	zeměpisná šířka	délka	nadmořská výška
";

  $l = explode("\n", $in);
  $out = "";
  for ($i=0; $i<sizeof($l)-1; $i++) {
    $l1 = explode("	", $l[$i]);
    $l2 = explode(" (", $l1[0]);
    $out .= "<a href=\"$cgi_file?phi=" . urlencode($l1[1]) . "&lambda=" . urlencode($l1[2]) . "\">$l2[0]</a> ($l2[1]	$l1[1]	$l1[2]	$l1[3] \n";
 }

  echo "$out</pre>

$footer
";

}

########################################################################

function get_shc_file() {

  default_values();
  print get_shc_contents();
}

########################################################################

function sunah_form() {
  global $header, $footer, $menu, $cgi_file, $lang, $msg;

# form vars
  global $phi, $lambda, $datum, $time, $dt, $nsteps, $precession,
    $nutation, $refraction;

  default_values();

  if ($precession == 1) $precession_check = " checked";
  if ($nutation   == 1) $nutation_check   = " checked";
  if ($refraction == 1) $refraction_check = " checked";

  echo "$header
$menu

<h2>" . $msg[$lang]['ephem'] . "</h2>

<form action=\"$cgi_file\" method=\"get\">

<p>" . $msg[$lang]['phi'] . " <small>[+DD:MM:SS]</small>
<input type=\"text\" size=\"10\" name=\"phi\" value=\"$phi\">

<p>" . $msg[$lang]['lambda'] . " <small>[+DD:MM:SS, " . $msg[$lang][''] . "kladně na V]</small>
<input type=\"text\" size=\"10\" name=\"lambda\" value=\"$lambda\">

<p>" . $msg[$lang]['datum'] . " <small>[YYYY/MM/DD]</small>
<input type=\"text\" size=\"10\" name=\"datum\" value=\"$datum\">

<p>" . $msg[$lang]['time'] . " <small>[HH:MM:SS]</small>
<input type=\"text\" size=\"10\" name=\"time\" value=\"$time\">

<p>" . $msg[$lang]['timestep'] . " <small>[HH:MM:SS]</small>
<input type=\"text\" size=\"10\" name=\"dt\" value=\"$dt\">

<p>" . $msg[$lang]['nsteps'] . "
<input type=\"text\" size=\"3\" name=\"nsteps\" value=\"$nsteps\">

<p>" . $msg[$lang]['precession'] . "
<input type=\"checkbox\" name=\"precession\" value=\"1\" offvalue=\"0\"$precession_check>

<p>" . $msg[$lang]['nutation'] . "
<input type=\"checkbox\" name=\"nutation\" value=\"1\"$nutation_check>

<p>" . $msg[$lang]['refraction'] . "
<input type=\"checkbox\" name=\"refraction\" value=\"1\"$refraction_check>

<input type=\"hidden\" name=\"type\" value=\"ephem\">
<input type=\"hidden\" name=\"lang\" value=\"$lang\">

<p><input type=\"submit\" name=\"submit\" value=\"" . $msg[$lang]['spocitat'] . "\">
<input type=\"submit\" name=\"ulozit\" value=\"" . $msg[$lang]['ulozit'] . "\">
<input type=\"reset\" value=\"" . $msg[$lang]['smazat'] . "\">
<a href=\"$cgi_file?type=ephem&lang=$lang\">" . $msg[$lang]['standard'] . "</a>

<p><small>" . $msg[$lang]['ulozit_notice'] . "</small>

$footer
";

}

########################################################################

function sunah() {
  global $header, $footer, $menu, $cgi_file, $QUERY_STRING, $lang, $msg;

# form vars
  global $phi, $lambda, $datum, $time, $dt, $nsteps, $precession,
    $nutation, $refraction;

# data files
  $data_file = array(
    "sunah.in",
    "*sunah.out",
  );

  default_values();

# create a writable temporary directory
  $rnd = rand();
  shell_exec("mkdir tmp/$rnd");

  $in_file = "tmp/$rnd/sunah.in";
  $fd = fopen($in_file, "w");
  $out = "$phi	/* zeměpisná šířka (phi) stanoviště [+DD:MM:SS] */
$lambda	/* zeměpisná délka (lambda) stanoviště [+DD:MM:SS, kladně na V] */
$datum	/* datum [YYYY/MM/DD] */
$time		/* počáteční světový čas [HH:MM:SS] *
$dt		/* časový krok dt [HH:MM:SS] */
$nsteps		/* počet kroků */
$precession		/* počítat s precesí? [0|1] */
$nutation		/* počítat s nutací? [0|1] */
$refraction		/* započítat refrakci? [0|1] */

";
  fwrite($fd, $out);
  fclose($fd);

  shell_exec("./sunah.sh tmp/$rnd");

  $out_file = "tmp/$rnd/sunah.out";
  $fd = fopen($out_file, "r");
  $out = fread($fd, filesize($out_file));
  fclose($fd);

  $tmp = preg_replace("/" . urlencode($msg[$lang]['spocitat']) . "/", "", $QUERY_STRING);
  $data = data_table($data_file, $rnd);

  echo "$header
$menu

<p>[ <a href=\"$cgi_file?$tmp\">" . $msg[$lang]['upravit_efemeridu'] . "</a>
| <a href=\"$cgi_file?type=ephem\">" . $msg[$lang]['novy'] . "</a> ]

<p>" . $msg[$lang]['ephem'] . ":

<pre>
$out</pre>

<p>" . $msg[$lang]['data'] . ":

<p><table border=\"0\" cellpadding=\"2\" cellspacing=\"0\">
$data
</table>

$footer
";

}

########################################################################

function casova_rce_zem_delka_form() {
  global $header, $footer, $menu, $cgi_file, $lang, $msg;

# form vars
  global $phi, $lambda;

  default_values();

  echo "$header
$menu

<h2>" . $msg[$lang]['casova_rce_zem_delka'] . "</h2>

<form action=\"$cgi_file\" method=\"get\">

<p>" . $msg[$lang]['phi'] . " <small>[+DD:MM:SS]</small>
<input type=\"text\" size=\"10\" name=\"phi\" value=\"$phi\">

<p>" . $msg[$lang]['lambda'] . " <small>[+DD:MM:SS, " . $msg[$lang][''] . "kladně na V]</small>
<input type=\"text\" size=\"10\" name=\"lambda\" value=\"$lambda\">

<input type=\"hidden\" name=\"type\" value=\"casova_rce_zem_delka\">
<input type=\"hidden\" name=\"lang\" value=\"$lang\">

<p><input type=\"submit\" name=\"submit\" value=\"" . $msg[$lang]['odeslat'] . "\">
<input type=\"submit\" name=\"ulozit\" value=\"" . $msg[$lang]['ulozit'] . "\">
<input type=\"reset\" value=\"" . $msg[$lang]['smazat'] . "\">
<a href=\"$cgi_file?type=casova_rce_zem_delka&lang=$lang\">" . $msg[$lang]['standard'] . "</a>

<p><small>" . $msg[$lang]['ulozit_notice'] . "</small>

$footer
";

}

########################################################################

function casova_rce_zem_delka() {
  global $header, $footer, $menu, $cgi_file, $QUERY_STRING, $lang, $msg;

# form vars
  global $phi, $lambda;

# data files
  $data_file = array(
    "casova_rce_zem_delka.in",
    "casova_rce_zem_delka.dat",
    "casova_rce_zem_delka.png",
    "*casova_rce_zem_delka1-1.pdf",
    "casova_rce_zem_delka1.1",
    "casova_rce_zem_delka2-1.pdf",
    "casova_rce_zem_delka2.1"
  );

  default_values();

# create a writable temporary directory
  $rnd = rand();
  shell_exec("mkdir tmp/$rnd");

  $fd = fopen("tmp/$rnd/casova_rce_zem_delka.in", "w");
  $out = "$phi	/* zeměpisná šířka (phi) stanoviště [+DD:MM:SS] */
$lambda	/* zeměpisná délka (lambda) stanoviště [+DD:MM:SS, kladně na V] */
2000/1/1	/* datum [YYYY/MM/DD] */
11:0:0		/* počáteční světový čas [HH:MM:SS] *
24:0:0		/* časový krok dt [HH:MM:SS] */
366		/* počet kroků */
1		/* počítat s precesí? [0|1] */
0	     	/* počítat s nutací? [0|1] */
0		/* započítat refrakci? [0|1] */

";
  fwrite($fd, $out);
  fclose($fd);

  shell_exec("./casova_rce_zem_delka.sh tmp/$rnd");

  $file = "tmp/$rnd/casova_rce_zem_delka.html";
  $fd = fopen($file, "r");
  $casova_rce_zem_delka_html = fread($fd, filesize($file));
  fclose($fd);

  $tmp = "type=casova_rce_zem_delka&phi=" . urlencode($phi) . "&lambda=" . urlencode($lambda);

# data files
  $data = data_table($data_file, $rnd);

  echo "$header
$menu

<p>[&nbsp;<a href=\"$cgi_file?$tmp\">" . $msg[$lang]['jine_stanoviste'] . "</a>
| <a href=\"$cgi_file?type=casova_rce_zem_delka\">" . $msg[$lang]['novy'] . "</a>&nbsp;]

<p>" . $msg[$lang]['casova_rce_zem_delka_graf'] . ":

<p><img src=\"tmp/$rnd/casova_rce_zem_delka.png\">

<p>$casova_rce_zem_delka_html

<p>" . $msg[$lang]['data'] . ":

<p><table border=\"0\" cellpadding=\"2\" cellspacing=\"0\">
$data
</table>

$footer
";

}

########################################################################

# Convert "HH:MM:SS" string to decimal hours.

function hmsh($s) {

  $l = preg_split("/:/", $s);
  $h = abs($l[0])+0.;
  if (sizeof($l) >= 3) {
    $h += $l[1]/60. + $l[2]/3600.;
  } else if (sizeof($l) == 2) {
    $h += $l[1]/60.;
  }
  if (!(strstr($l[0], "-") === false))
    $h = -$h;

  return $h;
}

########################################################################

# Signum of x.

function sgn($x) {

  if ($x > 0.)
    return 1;
  else if ($x < 0.)
    return -1;
  else
    return 0;
}

########################################################################

?>
