#!/bin/sh

# shc.sh
# Spusteni shcnox & co. v shellu, volano ze shc.php.
# Miroslav Broz (miroslav.broz@email.cz), Jun 17th 2007

# smaz stare docasne podadresare v tmp/
find ./tmp -maxdepth 1 -mmin +30 -exec rm -r {} \;

TMP=$1
cd $TMP

PATH=../..:$PATH

GDFONTPATH=./; export GDFONTPATH
ln -s ../../Luxi.pfa

shcnox < shc.in > shc.out
gnuplot ../../shc.plt

shc_eps.awk < shc.tmp > shc.eps
shc_A4.awk --limit < shc_A4.tmp > shc_A4.ps
popisky.awk < popisky.dat > popisky.ps
ps2pdf.sh shc.ps popisky.ps
ps2ai.sh shc.eps popisky.ps
pswrite.sh popisky.ps

zip -q shc.zip \
	analema.dat analema_prumet.dat \
	ciselnik.dat ciselnik.plt \
	datum.dat datum_prumet.dat \
	hodin.dat hodin_okraj.dat hodin_prumet.dat hodin_rysky.dat \
	horiz.dat horiz_rysky.dat \
	korekce.dat nodus.dat \
	temporal_prumet.dat temporal_rysky.dat \
	vychod_prumet.dat vychod_rysky.dat \
	zapad_prumet.dat zapad_rysky.dat \
	popisky.dat popisky.plt popisky.ps popisky.pdf \
	shc.png shc.ps shc.eps shc_A4.ps shc.pdf \
 	shc.ai popisky.ai popisky_krivky.ps \
	shc.in shc.out shc.shc \
	casova_rce_zem_delka1.1 casova_rce_zem_delka1-1.pdf \
	casova_rce_zem_delka2.1 casova_rce_zem_delka2-1.pdf 

cd ../..
chmod -f -R og+w $TMP

exit


