#!/usr/bin/awk -f

# shc_A4.awk
# Prevod velkoplosneho PS obrazku na vicestrankovy A4 (A3) dokument.
# Miroslav Broz (miroslav.broz@email.cz), Apr 16th 2003

# Pouziti: shc_A4.awk [-a3] [-l|--limit] < shc_A4.tmp > shc_A4.ps
# nebo ve Windows gawk.exe -f shc_A4.awk ...

BEGIN{

# rozmer papiru A4 v pt (72.27 pt = 1 in = 2.54 cm)
  a4_x = 596;	# 210 mm
  a4_y = 842;	# 297 mm
# rozmer papiru A3 v pt
  a3_x = 842;
  a3_y = 1191;
# velikosti okraju v pt
  margin_x = 50;
  margin_y = 50;
# zakonceni car
  setlinecap = 1;
  setlinejoin = 1;
# horni limit na velikost vystupniho souboru v MB
  limit_output = 10;

  papersize = "a4";
  MB = 1024*1024;
  limit = 0;

# argumenty na prikazovem radku
  for (i = 0; i < ARGC; i++) {

    if (ARGV[i] == "-a3") {
      a4_x = a3_x;
      a4_y = a3_y;
      papersize = "a3"
      ARGV[i] = "";

    } else if ((ARGV[i] == "-l") || (ARGV[i] == "--limit")) {
      limit = limit_output*MB;
      ARGV[i] = "";
    }
  }

  iprint = 0;
  iprolog = 1;
}
/%%BoundingBox:/{
  bbox_x = $4-$2;
  bbox_y = $5-$3;
  print "%%BoundingBox: 0 0 " a4_x " " a4_y;
  print "%%DocumentPaperSizes: " papersize;
  iprint = 1;
}
(iprint == 0) && (iprolog == 1){
  print;
}
(iprint == 0) && (iprolog == 0){
   body = $0;
}
/%%EndProlog/{
  iprolog = 0;
  RS = ""; # zmena separatoru!
}
{
  iprint = 0;
}
END{

# zkontroluj limit na velikost vystupu
  a4_w = a4_x - 2*margin_x;
  a4_h = a4_y - 2*margin_y;

  npages = (int(bbox_y/a4_h)+1) * (int(bbox_x/a4_w)+1);

  if ((limit != 0) && (length(body)*npages > limit)) {
    print \
      "50 50 moveto\n" \
      "(Helvetica) findfont 10 scalefont setfont\n" \
      "(sh\137A4.awk: ) show\n" \
      "(Size of output file exceeds the limit " limit_output " MB. ) show\n" \
      "(Velikost vystupniho souboru prekracuje " limit_output " MB. ) show\n" \
      "showpage\n" \
      "end\n" \
      "%%Trailer\n" \
      "%%DocumentFonts: Helvetica\n" \
      "%%Pages: 1";
    exit;
  }

# vyjmi Pages, Trailer and DocumentFonts z tela PostScriptu
  RS = "\n";
  body = gensub("%%Trailer\n", "", "g", body);
  dfonts = "%%DocumentFonts: ";
  dfonts = gensub(".*(" dfonts "[^\n]*)\n.*", "\\1", "g", body);
  body = gensub(dfonts "\n", "", "g", body);
  body = gensub("showpage\n%%Pages: 1", "showpage", "g", body);

  n = 0;

  for (j = 0; j < bbox_y/a4_h; j++) {
    if ((j+1)*a4_h < bbox_y) maxy = margin_y+a4_h; else maxy = margin_y+bbox_y-j*a4_h;	# okraj na konci ciselniku

    for (i = 0; i < bbox_x/a4_w; i++) {
      n++;
      x = margin_x-i*a4_w;
      y = margin_y-j*a4_h;

      if ((i+1)*a4_w < bbox_x) maxx = margin_x+a4_w; else maxx = margin_x+bbox_x-i*a4_w;

      clip = "newpath " margin_x " " margin_y " moveto " \
        maxx " " (margin_y) " lineto " \
        maxx " " maxy " lineto " \
        (margin_x) " " maxy " lineto " \
        "closepath clip";

      out = gensub("%%Page: 1 1", "%%Page: " n " " n, "g", body);
      out = gensub("50 50 translate", clip "\n" x " " y  " translate\n" setlinecap " setlinecap\n" setlinejoin " setlinejoin", "g", out);
      print out;
    }
  }
  print "%%Trailer";
  print dfonts;
  print "%%Pages: " n;
}

