#!/usr/bin/awk -f

# shc_eps.awk
# Prevod EPS obrazku do formatu pro rezaci plotter (misto plnych car obrysy).
# Miroslav Broz (miroslav.broz@email.cz), Jun 17th 2007

# Pouziti: shc_eps.awk < shc.tmp > shc.eps

BEGIN{
# nasobek tlousky vyrezavanych car
  LWSCALE = 1;

  iprint = 0;
  prolog = 1;
  n = 0;
  pi = 3.14159265;
  rad = 180/pi;
  eps = 1;
}

(/^[- 0-9\.]+ [MR]/ || /^[0-9\.]+ UL$/ || /^stroke$/) && (n > 0) && (prolog==0){
  if ((abs(ax[0]-ax[n]) < eps) && (abs(ay[0]-ay[n]) < eps)) {	# uzavrena krivka
    ax[-1] = ax[n-1];
    ay[-1] = ay[n-1];
    ax[n+1] = ax[1];
    ay[n+1] = ay[1];
    iclosed = 1;
  } else {
    ax[-1] = ax[0] + (ax[0]-ax[1]);
    ay[-1] = ay[0] + (ay[0]-ay[1]);
    ax[n+1] = ax[n] + (ax[n]-ax[n-1]);
    ay[n+1] = ay[n] + (ay[n]-ay[n-1]);
    iclosed = 0;
  }
  an(-1,0,1);
  print anx " " any " M";
  for (i = 1; i <= n; i++) {
    an(i-1,i,i+1);
    print anx " " any " L";
  }
  if (iclosed == 1) {
    an(1,0,-1);
    print anx " " any " M";
  } else {
    an(n+1,n,n-1);
    print anx " " any " L";
  }
  for (i = n-1; i >= 0; i--) {
    an(i+1,i,i-1);
    print anx " " any " L";
  }
  if (iclosed == 0) {
    an(-1,0,1);
    print anx " " any " L";
  }
#  print "n="n;
  n = 0;
}
/^[0-9\.]+ UL$/ && (prolog==0){
  print "1.000 UL";
  iprint = 1;
  LW = LWSCALE*2*$1;
}
/^[- 0-9\.]+ M/ && (prolog==0){
  cx = $1;
  cy = $2;
  ax[n] = cx;
  ay[n] = cy;
  iprint = 1;
}
/^[- 0-9\.]+ R/ && (prolog==0){
# prevod do absolutnich souradnic (rmoveto -> moveto)
  cx = cx + $1;
  cy = cy + $2;
  ax[n] = cx;
  ay[n] = cy;
  iprint = 1;
}
/^[- 0-9]+ L/ && (prolog==0){
  cx = $1;
  cy = $2;
  n++;
  ax[n] = cx;
  ay[n] = cy;
  iprint = 1;
}
/^[- 0-9]+ V/ && (prolog==0){
  cx = cx + $1;
  cy = cy + $2;
  n++;
  ax[n] = cx;
  ay[n] = cy;
  iprint = 1;
}
/^%%EndProlog/{
  prolog=0;
}
(iprint == 0) {
  print;
}
{
  iprint = 0;
}

func an(i,j,k, a,b,c,tmp){
  a = atan2(ay[j]-ay[i], ax[j]-ax[i]);
  b = atan2(ay[k]-ay[j], ax[k]-ax[j]);
  if (a < 0) { a = a + 2*pi; }
  if (b < 0) { b = b + 2*pi; }
  if (a < b) { a = a + 2*pi; }
  c = 0.5*(a+b);
  tmp = LW/cos(c-a);
  c = c-pi/2.;
#  print "a,b,c=" a*rad,b*rad,c*rad;
  anx = ax[j] + tmp*cos(c);
  any = ay[j] + tmp*sin(c);
  return;
}

func abs(x) {
  if (x < 0) {
    return -x;
  } else {
    return x;
  }
}

