#!/usr/bin/perl

# azed.pl
# Zpracovani mereni azimutu steny (format viz azed.in).
# Miroslav Broz (miroslav.broz@email.cz), Aug 20th 2005

@months = ("ledna", "nora", "bezna", "dubna", "kvtna", "ervna", "ervence", "srpna", "z", "jna", "listopadu", "prosince");

@in = <STDIN>;

print "# azimut zdi A [deg] & azimut Slunce A_\\odot [deg] & datum a cas UT\n";

$i = 0;
$j = 0;
foreach $l (@in) {
  $l =~ s/\n//;
  $i++;
  if ($i == 1) {
    $phi = $l;
  } elsif ($i == 2) {
    $lambda = $l;
  } else {
    @l1 = split(/\s+/,$l);
    $uhel = $l1[0];
    if (@l1 >= 2) {
      $time = $l1[1];
    }
    if (@l1 >= 3) {
      $date = $l1[2];

#  kontrola datumu (pro jistotu, ze...)
      ($year, $month, $day) = split(/\//,$date);
      if (($year < 1950) || ($year > 2050) || ($month < 1) || ($month > 12) || ($day < 1) || ($day > 31)) {
        print "# azed.pl: toto je ale podezel datum (!): $date\n";
      }
    }
    if (@l1 > 0) {

      open(in,">sunah.in");
      print in <<EOF ;
$phi
$lambda
$date	/* datum [YYYY/MM/DD] */              
$time		/* poten svtov as [HH:MM:SS] */
1:0:0		/* asov krok dt [HH:MM:SS] */       
1		/* poet krok */                     
1		/* potat s preces? [0|1] */        
0		/* potat s nutac? [0|1] */         
0		/* zapotat refrakci? [0|1] */       

EOF
      close in;

      $out = qx!./sunah < sunah.in!;
      $out =~ s/^#.*\n//gm;
      @l1 = split(/\s+/,$out);

      $azsun  = $l1[7];

      $year   = $l1[1];
      $month  = $l1[2];
      $day    = $l1[3];
      $hour   = $l1[4];
      $minute = $l1[5];
      $second = $l1[6];
      $minute = $minute + $second/60;

      $j++;
      $azed[$j] = $azsun + $uhel;
      if ($azed[$j] > 180) {
        $azed[$j] -= 360;
      }

      printf("%.3f		%.3f	%d. %s	%d  %2d h %4.1f min UT\n", $azed[$j], $azsun, $day, $months[$month-1], $year, $hour, $minute);
    }
  }
}

$n = $j;
if ($n < 2) {
  exit;
}

$avg = 0;
for ($i = 1; $i <= $n; $i++) {
  $avg += $azed[$i];
}
$avg = $avg/$n;

$sig = 0;
for ($i = 1; $i <= $n; $i++) {
  $sig += ($azed[$i] - $avg)**2;
}
$sig = sqrt($sig)/($n - 1);

printf("azed = (%.3f +- %.3f) deg\n", $avg, $sig);

exit;

